﻿using System;

namespace KursBeispiele
{
    class Program
    {
        static void Main(string[] args)
        {
            Unterklasse u1 = new Unterklasse();
            Unterklasse u2 = new Unterklasse(5);

            Test();
            //GC Ruft den Garbage Collector auf,
            //der den Destruktor in diesem Fall aufruft
            GC.Collect();
            //Beachten: u1 und u2 werden noch nicht vernichtet obwohl nicht mehr genutzt
            //nur u3 wird vernichtet - steht in Funktion die abgeschlossen wurde!
            Console.Read();
        }

        private static void Test()
        {
            Unterklasse u3 = new Unterklasse(7);
        }
    }

    public class Oberklasse
    {
        //Wenn wir nichts davor schreiben ist nummer
        //private d.h. nicht sichtbar in der UK - 
        //wir machen nummer nun protected daher ist die
        //Variable von außen nicht sichtbar, wird aber als
        //private geerbt und ist somit in der UK sichtbar
        protected int nummer;

        public Oberklasse(int nummer)
        {
            this.nummer = nummer;
            Console.WriteLine("Nummer ist " + nummer);
        }

        //Hier könnte sogar ein
        //protected leerer Konstruktor hilfreich sein - 
        //weiterhin von außen nicht sichtbar aber wird
        //vererbt und kann somit von Unterklasse verwendet
        //werden
        protected Oberklasse() : this(0)
        {
        }
    }

    public class Unterklasse : Oberklasse
    {
        //benötigt eine klare Konstruktoransage, da
        //Oberklasse keinen Standardkonstruktor mit 0
        //Argumenten enthält
        public Unterklasse()
        {
            Console.WriteLine("Ich bin der Konstruktor der den protected OK aufruft");
        }

        public Unterklasse(int nummer)
            : base(nummer)
        {
            Console.WriteLine("Ich bin der Konstruktor der den public OK aufruft");
        }

        ~Unterklasse()
        {
            Console.WriteLine("I've been destroyed!! Die Nummer war " + base.nummer);
        }
    }
}
